#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'

require_relative '../..//module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../..//pages/landing'
require_relative '../../pages/login'
require_relative '../../helper/modal'
require_relative '../../pages/eula'
require_relative '../../pages/roa'
require_relative '../../pages/user_menu'
require_relative '../../pages/launchpad'
require_relative '../../common/common'
require_relative '../../pages/landing_appointments'

describe '[Story# VAR-1748: Landing - Not authenticated ]
          [Story# VAR-2270: Landing Page - Not Authenticated]
          [Story# VAR-4079: Update app version on footer and about page]
          [Story# VAR-12417: Automate Version Number Update 4.6.0]' do

  include DriverUtility

  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing = Landing.new(@driver)
    @login = Login.new(@driver)
    @eula = Eula.new(@driver)
    @roa = Roa.new(@driver)
    @user_menu = UserMenuOption.new(@driver)
    @launchpad = Launchpad.new(@driver)
    @modal = Modal.new(@driver)
    @common = Common.new(@driver)
    @landing_appointments = LandingAppointments.new(@driver)
  end

  after(:all) do
    @driver.close
  end

  context '[AC#VAR-1804|TC#VAR-1901 - Landing Page - Not Authenticated]
           [AC#VAR-2762,2344|TC#VAR-2768 - Rework Landing Page - Not Authenticated]
           [AC#VAR-4148|TC#VAR-4149 - App version update]
           [AC#VAR-5151|TC#VAR-5152: Validate Automate Version Number Update] ' do

    it "EULA" do
      Watir::Wait.until {@eula.accept_element.exists?}
      @eula.accept_element.when_present(TIME_OUT_LIMIT)
      expect(@eula.has_expected_title?).to eq(true)
      expect(@eula.accept_element.present?).to eq(true)
      @common.waitWhileSpinnerPresent

      @eula.accept_element.click
      @common.waitWhileSpinnerPresent
    end

    it "Verified screen content" do
      actual_content = @landing.screen_content.split("\n")
      if(@landing.isCCEnabled ==true)
        expected_content=[\
                        "Welcome to VA Appointments App",
                        "Welcome to VA Appointments",
                        "The VA Appointment app allows patients to:",
                        "Schedule appointments for supported types of care directly with the VA facility.",
                        "Submit requests to a scheduling clerk for a VA facility appointment.",
                        "Submit requests for non VA appointments (Community Care) to a scheduling clerk (distance eligible veterans only).",
                        "Learn About Community Care",
                        "",
                        "NOTE: This app is not monitored by your VA doctors. If you need urgent care, please Dial 911",
                        "Dial 9 1 1 from your mobile device", "or call the Veterans Crisis Hotline at 1-800-273-8255",
                        "Dial the VA Veteran Crisis Hotline from your mobile device",
                        "and press 1.",
                        "For urgent matters related to an appointment within the next 72 hours, please call your facility. View VA Facilities.",
                        "Login"
        ]
        elsif(@landing.isCCEnabled ==false)

      expected_content=[\
                        "Welcome to VA Appointments App",
                        "Welcome to VA Appointments",
                        "The VA Appointment app allows patients to:",
                        "Schedule appointments for supported types of care directly with the VA facility.",
                        "Submit requests to a scheduling clerk for a VA facility appointment.",
                        "NOTE: This app is not monitored by your VA doctors. If you need urgent care, please Dial 911",
                        "Dial 9 1 1 from your mobile device", "or call the Veterans Crisis Hotline at 1-800-273-8255",
                        "Dial the VA Veteran Crisis Hotline from your mobile device",
                        "and press 1.",
                        "For urgent matters related to an appointment within the next 72 hours, please call your facility. View VA Facilities.",
                        "Login"
      ]
      end

      expected_content.each_with_index do | expectedScreenRow, i |
        expect(expectedScreenRow.strip).to include(actual_content[i].strip)
      end
    end

    it "App header bar: VA Appointments" do
      #expect(@landing.has_expected_title?).to eq(true)
      @landing.landing_page_title_element.when_visible(TIME_OUT_LIMIT)
      expect(@landing.landing_page_title_element.text).to eq("Welcome to VA Appointments")
      expect(@landing.text).to eq("The VA Appointment app allows patients to:")
    end

    it "Text for allowed methods" do
      expected_content =[\
                        "Schedule appointments for supported types of care directly with the VA facility.",
                        "Submit requests to a scheduling clerk for a VA facility appointment."]
      actual_content = @landing.methods_allowed.split("\n")
      expected_content.each_with_index do | expectedScreenRow, i |
        expect(expectedScreenRow.strip).to include(actual_content[i].strip)
      end
    end

    it "Validate urgent care message" do
      #@landing.infoLine1_element.when_visible(TIME_OUT_LIMIT)
      expect(@landing.infoLine1).to eq("NOTE: This app is not monitored by your VA doctors. If you need urgent care, please Dial 911\nDial 9 1 1 from your mobile device\nor call the Veterans Crisis Hotline at 1-800-273-8255\nDial the VA Veteran Crisis Hotline from your mobile device\nand press 1.\nFor urgent matters related to an appointment within the next 72 hours, please call your facility. View VA Facilities.")

    end

    it "Validate 911 modal" do
      #Select Dial 911 and verify the confirmation modal
      @landing.dial911
      @landing.confirmModalTitle_element.when_visible(TIME_OUT_LIMIT)
      expect(@landing.confirmModalTitle_element.text).to eq("Confirmation")
      expect(@landing.confirmText).to eq("You are about to dial the number on your mobile device. Select CONTINUE to proceed, or select RETURN to return to the VA Appointments app.")
    end

    it "Validate clicking return takes back to landing page" do
      @landing.return

      #Confirmation Continue
      expect(@landing.has_expected_title?).to eq(true)
      @landing.landing_page_title_element.when_visible(TIME_OUT_LIMIT)
      expect(@landing.landing_page_title_element.text).to eq("Welcome to VA Appointments")
    end

    it "Validate continue for 911 takes you to call window" do
      @landing.dial911
      @landing.confirmModalTitle_element.when_visible(TIME_OUT_LIMIT)
      expect(@landing.confirmModalTitle_element.text).to eq("Confirmation")
      @landing.continue

      #Dial 911 call window
      switchWindowToWindowHandleLast
      expect(getCurrentURL).to eq("about:blank")
    end

    it "Close window and return to landing" do
      switchWindowToWindowHandleFirst
      @landing.landing_page_title_element.when_visible(TIME_OUT_LIMIT)
      expect(@landing.landing_page_title_element.text).to eq("Welcome to VA Appointments")

    end

    it "Dial Veteran Crisis Phone number link modal" do
      @landing.dialVeteranCrisisLink
      @landing.confirmModalTitle_element.when_visible(TIME_OUT_LIMIT)
      expect(@landing.confirmModalTitle_element.text).to eq("Confirmation")
      expect(@landing.confirmText).to eq("You are about to dial the number on your mobile device. Select CONTINUE to proceed, or select RETURN to return to the VA Appointments app.")
    end

    it "clicking return takes you back to landing page" do
      @landing.return

      #Confirmation Continue
      expect(@landing.has_expected_title?).to eq(true)
      @landing.landing_page_title_element.when_visible(TIME_OUT_LIMIT)
      expect(@landing.landing_page_title_element.text).to eq("Welcome to VA Appointments")
    end

    it "clicking continue takes you to crisis link dial window" do
      @landing.dialVeteranCrisisLink
      @landing.confirmModalTitle_element.when_visible(TIME_OUT_LIMIT)
      @landing.continue

      #Dial Veteran Crisis call window
      switchWindowToWindowHandleLast
      expect(getCurrentURL).to eq("about:blank")
    end

    it "close and return back to landing from crisis window" do
      switchWindowToWindowHandleFirst
      @landing.landing_page_title_element.when_visible(TIME_OUT_LIMIT)
      expect(@landing.landing_page_title_element.text).to eq("Welcome to VA Appointments")
    end

    it "Select Dial 911 Phone Image" do

      expect(@landing.dial911Image_element.attribute("alt")).to eq("Dial 9 1 1 from your mobile device")
    end

    it "clicking on dial 911 image confirmation modal" do
      @landing.dial911Image_link
      @landing.confirmModalTitle_element.when_visible(TIME_OUT_LIMIT)
      expect(@landing.confirmModalTitle_element.text).to eq("Confirmation")
      expect(@landing.confirmText).to eq("You are about to dial the number on your mobile device. Select CONTINUE to proceed, or select RETURN to return to the VA Appointments app.")
    end

    it "clicking return takes you back to landing page" do
      @landing.return

      #Confirmation Continue

      @landing.landing_page_title_element.when_visible(TIME_OUT_LIMIT)
      expect(@landing.landing_page_title_element.text).to eq("Welcome to VA Appointments")
    end

    it "clicking continue from 911 image modal takes you to dial screen" do
      @landing.dial911Image_link
      @landing.confirmModalTitle_element.when_visible(TIME_OUT_LIMIT)
      @landing.continue

      #Dial 911 call window
      switchWindowToWindowHandleLast
      expect(getCurrentURL).to eq("about:blank")
    end

    it "close and retuen back to landing page" do
      switchWindowToWindowHandleFirst
      @landing.landing_page_title_element.when_visible(TIME_OUT_LIMIT)
      expect(@landing.landing_page_title_element.text).to eq("Welcome to VA Appointments")
    end

    it "Select Veteran Crisis Phone Image" do
      expect(@landing.dialVeteranCrisisImage_element.attribute("alt")).to eq("Dial the VA Veteran Crisis Hotline from your mobile device")
    end

    it "Clicking on crisis image open the confirmation modal" do
      @landing.dialVeteranCrisisImage_link
      @landing.confirmModalTitle_element.when_visible(TIME_OUT_LIMIT)
      expect(@landing.confirmModalTitle_element.text).to eq("Confirmation")
      expect(@landing.confirmText).to eq("You are about to dial the number on your mobile device. Select CONTINUE to proceed, or select RETURN to return to the VA Appointments app.")
    end

    it "click return to go back to landing" do
      @landing.return

      #Confirmation Continue
      @landing.landing_page_title_element.when_visible(TIME_OUT_LIMIT)
      expect(@landing.landing_page_title_element.text).to eq("Welcome to VA Appointments")
    end

    it "click continue on crisis image modal to go to dial screen" do
      @landing.dialVeteranCrisisImage_link
      @landing.confirmModalTitle_element.when_visible(TIME_OUT_LIMIT)
      @landing.continue

      #Dial Veteran Crisis call window
      switchWindowToWindowHandleLast
      expect(getCurrentURL).to eq("about:blank")
    end

    it "close and return back to landing" do
      switchWindowToWindowHandleFirst
      @landing.landing_page_title_element.when_visible(TIME_OUT_LIMIT)
      expect(@landing.landing_page_title_element.text).to eq("Welcome to VA Appointments")
    end

    it "Select View VA Facility link" do
      @landing.vaFacilityLink
      @landing.confirmModalTitle_element.when_visible(TIME_OUT_LIMIT)
      expect(@landing.confirmModalTitle_element.text).to eq("Confirmation")
      expect(@landing.confirmText).to eq("You are about to leave the VA Appointments app. Select CONTINUE to proceed to the link information selected, or select RETURN to return to the VA Appointments app.")
      expect(@modal.buttons_elements[1].text).to eq("Return")
    end

    it "clicking return from View VA facilities returns to landing" do
      @modal.buttons_elements[1].click

      #Confirmation Continue
      @landing.landing_page_title_element.when_visible(TIME_OUT_LIMIT)
      expect(@landing.landing_page_title_element.text).to eq("Welcome to VA Appointments")
    end

    it "continue to view VA facilities" do
      @landing.vaFacilityLink
      @landing.confirmModalTitle_element.when_visible(TIME_OUT_LIMIT)
      @modal.buttons_elements[0].click

      #Visiting external site
      switchWindowToWindowHandleLast
      expect(getCurrentURL).to eq("https://www.DOMAIN.EX/directory/guide/division.asp?dnum=1")
    end

    it "Close and return back to landing" do
      switchWindowToWindowHandleFirst
      @landing.landing_page_title_element.when_visible(TIME_OUT_LIMIT)
      expect(@landing.landing_page_title_element.text).to eq("Welcome to VA Appointments")
    end

    it "Verify login button is present" do
      @landing.login_element.when_visible(TIME_OUT_LIMIT)
      expect(@landing.has_expected_title?).to eq(true)
      expect(@landing.login_element.visible?).to eq(true)
    end


    xit "Login with not authenticated user" do
      @landing.login
      @login.login_element.when_visible(TIME_OUT_LIMIT)
      expect(@login.has_expected_title?).to eq(true)
      @login.login_without_passing_ROA("zztest.patient01", "pass", "D123401")
    end

    xit "ROA not accepted.  Accept ROA" do
      @roa.title_element.when_present
      !(45).times{ break if (@roa.title == "Right Of Access"); sleep 1 }

      @roa.nextButton_element.when_visible(TIME_OUT_LIMIT)
      expect(@roa.has_expected_title?).to eq(true)
      @roa.nextButton

      @roa.verify_element.when_visible(TIME_OUT_LIMIT)
      @roa.verify
    end

    xit "Landing page" do
      @common.waitWhileSpinnerPresent
      @landing.footerUserInfo_element.when_visible(TIME_OUT_LIMIT)
      Watir::Wait.until {@landing.footerUserInfo == "Logged in as patient01, zztest"}
      expect(@landing.footerUserInfo).to eq("Logged in as patient01, zztest")
      @common.waitWhileSpinnerPresent
      @landing_appointments.primary_header_element.when_present(TIME_OUT_LIMIT)
      expect(@landing_appointments.primary_header).to eq("Appointments/Requests")
      expect(@landing_appointments.request_header).to eq("Requests")

    end

    xit "Logout and Log in again and verify ROA screen does not display" do
      @user_menu.userMenu_element.when_present(TIME_OUT_LIMIT)
      @user_menu.userMenu
      @user_menu.logOut

      @launchpad.login_element.when_visible(TIME_OUT_LIMIT)

      goTo(VAR_BASE_URL)
      @landing.landing_page_title_element.when_visible(TIME_OUT_LIMIT)
      expect(@landing.has_expected_title?).to eq(true)

      @landing.login_element.when_visible(TIME_OUT_LIMIT)
      @landing.login

      @login.login_element.when_visible(TIME_OUT_LIMIT)
      expect(@login.has_expected_title?).to eq(true)
      @login.login_with(VarVeteran01)

      @common.waitWhileSpinnerPresent

      @landing_appointments.primary_header_element.when_present(TIME_OUT_LIMIT)

      @common.waitWhileSpinnerPresent

      Watir::Wait.until { @landing_appointments.add_top_btn_element.present? }
      @landing_appointments.add_top_btn_element.when_present(TIME_OUT_LIMIT)


      @landing.footerUserInfo_element.when_present(TIME_OUT_LIMIT)
      Watir::Wait.until {@landing.footerUserInfo == "Logged in as patient01, zztest"}
      expect(@landing.footerUserInfo).to eq("Logged in as patient01, zztest")
    end

  end
end





T